/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public final class TextUtils {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{}");
    private static final UUID MOD_UUID = UUID.nameUUIDFromBytes("summoningrituals".getBytes());

    private TextUtils() {
    }

    public static String f(String input, Object ... args) {
        for (Object arg : args) {
            input = PLACEHOLDER.matcher(input).replaceFirst(arg.toString());
        }
        for (int i = 0; i < args.length; ++i) {
            input = input.replace("{" + i + "}", args[i].toString());
        }
        return input;
    }

    public static ResourceLocation getRL(String key) {
        return new ResourceLocation("summoningrituals", key);
    }

    public static String translateAsString(String type, String key) {
        return TextUtils.translate(type, key, new ChatFormatting[0]).getString();
    }

    public static TranslatableComponent translate(String type, String key, ChatFormatting ... color) {
        TranslatableComponent output = new TranslatableComponent(TextUtils.getTranslationKey(type, key));
        return color.length == 0 ? output : (TranslatableComponent)output.m_130940_(color[0]);
    }

    public static void sendPlayerMessage(@Nullable Player player, String translationKey, ChatFormatting color, Object ... args) {
        if (player == null) {
            return;
        }
        player.m_6352_((Component)new TranslatableComponent(TextUtils.getTranslationKey("message", translationKey), args).m_130940_(color), MOD_UUID);
    }

    public static TextComponent colorize(String input, ChatFormatting color) {
        return (TextComponent)new TextComponent(input).m_130940_(color);
    }

    private static String getTranslationKey(String type, String key) {
        return String.format("%s.%s.%s", type.toLowerCase(), "summoningrituals", key);
    }
}

